#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  Greenish CityMod01.fsh    by      benny00100
//https://www.shadertoy.com/view/WcsSzr
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Complex 3D City with Matrix-style Grid
// For Shadertoy

#define MAX_STEPS 100
#define MAX_DIST 100.0
#define SURF_DIST 0.001

// Rotation function
mat2 Rot(float a) {
    float s = sin(a);
    float c = cos(a);
    return mat2(c, -s, s, c);
}

// Distance field for a box
float Box(vec3 p, vec3 b) {
    vec3 q = abs(p) - b;
    return length(max(q, 0.0)) + min(max(q.x, max(q.y, q.z)), 0.0);
}

// Scene distance function
float GetDist(vec3 p) {
    // Ground plane
    float planeDist = p.y;
    
    // City buildings
    vec3 bp = p;
    bp.xz = mod(p.xz + 5.0, 10.0) - 5.0; // Repeating pattern
    float buildingHeight = 2.0 + sin(p.x * 0.1) * cos(p.z * 0.1) * 5.0;
    float building = Box(bp - vec3(0, buildingHeight, 0), vec3(1.5, buildingHeight, 1.5));
    
    return min(planeDist, building);
}

// Ray marching
float RayMarch(vec3 ro, vec3 rd) {
    float dO = 0.0;
    for(int i = 0; i < MAX_STEPS; i++) {
        vec3 p = ro + rd * dO;
        float dS = GetDist(p);
        dO += dS;
        if(dO > MAX_DIST || abs(dS) < SURF_DIST) break;
    }
    return dO;
}

// Normal calculation
vec3 GetNormal(vec3 p) {
    float d = GetDist(p);
    vec2 e = vec2(0.001, 0);
    vec3 n = d - vec3(
        GetDist(p - e.xyy),
        GetDist(p - e.yxy),
        GetDist(p - e.yyx));
    return normalize(n);
}

// Simple lighting with reflection
vec3 GetLight(vec3 p, vec3 ro, vec3 rd) {
    vec3 lightPos = vec3(5.0, 10.0, -5.0);
    lightPos.xz += vec2(sin(iTime), cos(iTime)) * 2.0;
    
    vec3 l = normalize(lightPos - p);
    vec3 n = GetNormal(p);
    vec3 v = normalize(ro - p);
    
    // Diffuse
    float dif = clamp(dot(n, l), 0.0, 1.0);
    
    // Specular
    vec3 r = reflect(-l, n);
    float spec = pow(clamp(dot(r, v), 0.0, 1.0), 32.0);
    
    // Reflection
    vec3 refl = reflect(rd, n);
    float reflStrength = 0.3;
    
    return vec3(dif * 0.7 + spec * 0.3) + refl * reflStrength;
}

// Matrix grid effect
vec3 MatrixGrid(vec2 uv, vec3 col) {
    vec2 grid = fract(uv * 20.0);
    float gridLine = smoothstep(0.95, 1.0, max(grid.x, grid.y)) - 
                    smoothstep(0.0, 0.05, min(grid.x, grid.y));
    return mix(col, vec3(0.0, 1.0, 0.2), gridLine * 0.5);
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord - 0.5 * iResolution.xy) / iResolution.y;
    
    // Camera setup
    vec3 ro = vec3(0.0, 5.0, -10.0 + iTime * 2.0);
    vec3 rd = normalize(vec3(uv.x, uv.y - 0.2, 1.0));
    
    // Camera rotation
    rd.xz *= Rot(iTime * 0.2);
    
    // Ray marching
    float d = RayMarch(ro, rd);
    vec3 col = vec3(0.0);
    
    if(d < MAX_DIST) {
        vec3 p = ro + rd * d;
        col = GetLight(p, ro, rd);
        // Matrix green tint
        col = mix(col, vec3(0.1, 0.2, 0.1), 0.5);
    }
    
    // Background
    col = mix(col, vec3(0.0, 0.16, 0.2), smoothstep(0.0, MAX_DIST, d));
    
    // Add Matrix grid overlay
    //col = MatrixGrid(uv + vec2(iTime * 0.1, 0.0), col);
    
    // Gamma correction
    col = pow(col, vec3(0.4545));
    
    fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

